"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const ava_1 = __importDefault(require("ava"));
const util_1 = require("./util");
ava_1.default("empty path", t => {
    t.deepEqual(util_1.extractSortValue(["foo", "bar"], { id: 1 }), undefined);
});
ava_1.default("empty value", t => {
    t.deepEqual(util_1.extractSortValue(["foo", "bar"], { id: 2, foo: {} }), undefined);
});
ava_1.default("number", t => {
    t.deepEqual(util_1.extractSortValue(["foo", "bar"], { id: 3, foo: { bar: 1 } }), 1);
});
ava_1.default("string", t => {
    t.deepEqual(util_1.extractSortValue(["foo", "bar"], { id: 4, foo: { bar: "a" } }), "a");
});
ava_1.default("multi number", t => {
    t.deepEqual(util_1.extractSortValue(["foo", "bar"], { id: 5, foo: { bar: [2] } }), 2);
});
ava_1.default("multi string", t => {
    t.deepEqual(util_1.extractSortValue(["foo", "bar"], { id: 6, foo: { bar: ["b"] } }), "b");
});
ava_1.default("multi string extracts first", t => {
    t.deepEqual(util_1.extractSortValue(["foo", "bar"], { id: 7, foo: { bar: ["x", "e"] } }), "x");
});
ava_1.default("multi complex object", t => {
    t.deepEqual(util_1.extractSortValue(["foo", "bar"], { id: 8, foo: { bar: [{ value: "c" }] } }), "c");
});
ava_1.default("multi complex object extracts primary", t => {
    t.deepEqual(util_1.extractSortValue(["foo", "bar"], {
        id: 9,
        foo: { bar: [{ value: "d" }, { value: "g", primary: true }] }
    }), "g");
});
ava_1.default("traverses nested multi", t => {
    t.deepEqual(util_1.extractSortValue(["foo", "bar"], { id: 10, foo: [{ bar: [3] }] }), 3);
});
//# sourceMappingURL=util.test.js.map