"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const apg_lib_1 = require("apg-lib");
function infixLogicalExpressionPredicate(state, chars, phraseIndex, phraseLength, yard) {
    switch (state) {
        case apg_lib_1.ids.SEM_PRE:
            yard.pre("infixLogicalExpressionPredicate");
            break;
        case apg_lib_1.ids.SEM_POST:
            const { infixLogicalExpressionOperator, expression } = yard.post("infixLogicalExpressionPredicate");
            if (infixLogicalExpressionOperator.length !== 1) {
                throw new Error(`INVARIANT: Expected 1 infixLogicalExpressionOperator, but got ${infixLogicalExpressionOperator.length};`);
            }
            if (expression.length !== 1) {
                throw new Error(`INVARIANT: Expected 1 expression, but got ${expression.length};`);
            }
            yard.tracks.infixLogicalExpressionPredicate.push([
                infixLogicalExpressionOperator[0],
                expression[0]
            ]);
            break;
    }
    return apg_lib_1.ids.SEM_OK;
}
exports.infixLogicalExpressionPredicate = infixLogicalExpressionPredicate;
//# sourceMappingURL=infixLogicalExpressionPredicate.js.map