"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Hogan = __importStar(require("hogan.js"));
var diff2html_templates_1 = require("./diff2html-templates");
var HoganJsUtils = (function () {
    function HoganJsUtils(_a) {
        var _b = _a.compiledTemplates, compiledTemplates = _b === void 0 ? {} : _b, _c = _a.rawTemplates, rawTemplates = _c === void 0 ? {} : _c;
        var compiledRawTemplates = Object.entries(rawTemplates).reduce(function (previousTemplates, _a) {
            var _b;
            var name = _a[0], templateString = _a[1];
            var compiledTemplate = Hogan.compile(templateString, { asString: false });
            return __assign(__assign({}, previousTemplates), (_b = {}, _b[name] = compiledTemplate, _b));
        }, {});
        this.preCompiledTemplates = __assign(__assign(__assign({}, diff2html_templates_1.defaultTemplates), compiledTemplates), compiledRawTemplates);
    }
    HoganJsUtils.compile = function (templateString) {
        return Hogan.compile(templateString, { asString: false });
    };
    HoganJsUtils.prototype.render = function (namespace, view, params, partials, indent) {
        var templateKey = this.templateKey(namespace, view);
        try {
            var template = this.preCompiledTemplates[templateKey];
            return template.render(params, partials, indent);
        }
        catch (e) {
            throw new Error("Could not find template to render '" + templateKey + "'");
        }
    };
    HoganJsUtils.prototype.template = function (namespace, view) {
        return this.preCompiledTemplates[this.templateKey(namespace, view)];
    };
    HoganJsUtils.prototype.templateKey = function (namespace, view) {
        return namespace + "-" + view;
    };
    return HoganJsUtils;
}());
exports.default = HoganJsUtils;
//# sourceMappingURL=hoganjs-utils.js.map