import { OData } from "../../..";
export declare type CharFilterName = PrebuiltCharFilterName | string;
export declare type CharFilter = MappingCharFilter | PatternReplaceCharFilter;
export declare enum PrebuiltCharFilterName {
    htmlStrip = "html_strip",
    mapping = "mapping",
    patternReplace = "pattern_replace"
}
export declare enum CharFilterType {
    mapping = "#Microsoft.Azure.Search.MappingCharFilter",
    patternReplace = "#Microsoft.Azure.Search.PatternReplaceCharFilter"
}
export interface MappingCharFilter extends OData<CharFilterType.mapping> {
    mappings: string[];
}
export interface PatternReplaceCharFilter extends OData<CharFilterType.patternReplace> {
    pattern: string;
    replacement: string;
}
