"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const response_error_1 = require("./response-error");
exports.jsonParser = (reviver) => {
    return (res, cb) => {
        const message = res; // superagent says this is 'Response' but it's really an 'IncomingMessage'
        const buf = [];
        message.on('data', (d) => buf.push(d));
        message.on('error', cb);
        message.on('end', () => {
            const bodyText = Buffer.concat(buf).toString().trim();
            const contentType = message.headers['content-type'];
            let error;
            let body;
            if (contentType && contentType.startsWith('application/json')) {
                try {
                    body = JSON.parse(bodyText, reviver);
                }
                catch (err) {
                    error = err;
                }
            }
            else {
                body = bodyText;
            }
            // error
            if (message.statusCode < 200 || message.statusCode >= 300) {
                let errorMessage;
                if (body && body.error && body.error.message) {
                    errorMessage = body.error.message;
                }
                else {
                    errorMessage = bodyText || message.statusMessage;
                }
                error = new response_error_1.ResponseError(message.statusCode, errorMessage);
            }
            cb(error, body);
        });
    };
};
//# sourceMappingURL=parsers.js.map