"use strict";
function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
Object.defineProperty(exports, "__esModule", { value: true });
const search_resource_group_1 = require("../search-resource-group");
const search_index_1 = require("./search-index");
__export(require("./builders"));
__export(require("./search-index"));
/** Manage an Azure Search index resource */
class Indexes extends search_resource_group_1.SearchResourceGroup {
    /**
     * Manage an Azure Search index resource
     * @param requester http handler
     */
    constructor(requester) {
        super(requester, 'indexes');
    }
    /**
     * Use a named search index
     * @param indexName name of the search index
     */
    use(indexName) {
        return new search_index_1.SearchIndex(this.requester, this.type, indexName);
    }
}
exports.Indexes = Indexes;
//# sourceMappingURL=index.js.map