"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const search_resource_1 = require("../search-resource");
/**
 * Manage an Azure Search indexer resource
 */
class Indexer extends search_resource_1.SearchResource {
    /**
     * Manage an Azure Search indexer resource
     * @param requester http handler
     * @param type must be 'indexers'
     * @param name name of the current indexer
     */
    constructor(requester, type, name) {
        super(requester, type, name);
    }
    run(optionsOrCallback, callback) {
        return this.request({
            method: 'post',
            path: '/run',
        }, optionsOrCallback, callback);
    }
    status(optionsOrCallback, callback) {
        return this.request({
            method: 'get',
            path: '/status',
        }, optionsOrCallback, callback);
    }
    reset(optionsOrCallback, callback) {
        return this.request({
            method: 'post',
            path: '/reset',
        }, optionsOrCallback, callback);
    }
}
exports.Indexer = Indexer;
//# sourceMappingURL=indexer.js.map