import { Indexer as IndexerSchema, IndexerStatusResult } from 'azure-search-types';
import { SearchRequester } from '../search-requester';
import { SearchResource } from '../search-resource';
import { AzureSearchResponse, SearchCallback, SearchOptions } from '../types';
export { IndexerStatusResult, IndexerSchema };
/**
 * Manage an Azure Search indexer resource
 */
export declare class Indexer extends SearchResource<IndexerSchema> {
    /**
     * Manage an Azure Search indexer resource
     * @param requester http handler
     * @param type must be 'indexers'
     * @param name name of the current indexer
     */
    constructor(requester: SearchRequester, type: string, name: string);
    /**
     * Run the current indexer
     * @param options optional search options
     */
    run(options?: SearchOptions): Promise<AzureSearchResponse<void>>;
    run(callback: SearchCallback<void>): void;
    run(options: SearchOptions, callback: SearchCallback<void>): void;
    /**
     * Get status for the current indexer
     * @param options optional search options
     */
    status(options?: SearchOptions): Promise<AzureSearchResponse<IndexerStatusResult>>;
    status(callback: SearchCallback<IndexerStatusResult>): void;
    status(options: SearchOptions, callback: SearchCallback<IndexerStatusResult>): void;
    /**
     * Reset tracking state for the current indexer
     * @param options optional search options
     */
    reset(options?: SearchOptions): Promise<AzureSearchResponse<void>>;
    reset(callback: SearchCallback<void>): void;
    reset(options: SearchOptions, callback: SearchCallback<void>): void;
}
