"use strict";
function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
Object.defineProperty(exports, "__esModule", { value: true });
const search_resource_group_1 = require("../search-resource-group");
const data_source_1 = require("./data-source");
__export(require("./data-source"));
/**
 * Manage Azure Search data source resources
 */
class DataSources extends search_resource_group_1.SearchResourceGroup {
    /**
     * Manage Azure Search data source resources
     * @param requester http handler
     */
    constructor(requester) {
        super(requester, 'datasources');
    }
    /**
     * Use a named data source
     * @param dataSourceName name of the data source
     */
    use(dataSourceName) {
        return new data_source_1.DataSource(this.requester, this.type, dataSourceName);
    }
}
exports.DataSources = DataSources;
//# sourceMappingURL=index.js.map