var identityProviderMapper = {
    map: function (context, user, idpConfig, mapperConfig, attributes) {
        var realm = context.getRealm();
        var groupAttribute = attributes.get("GROUP"); // Adjust based on actual SAML attribute

        if (!groupAttribute) {
            return;
        }

        // Ensure "Intermate members" exists
        var baseGroup = realm.getGroupByPath("/Intermate members");
        if (!baseGroup) {
            baseGroup = realm.createGroup("Intermate members");
        }

        // Convert SAML attribute to an array
        var userGroups = Array.isArray(groupAttribute) ? groupAttribute : [groupAttribute];

        // Get all existing groups assigned to the user
        var existingGroups = user.getGroups();
        var assignedGroups = [];

        // Assign user to "Intermate members"
        user.joinGroup(baseGroup);

        // Assign user to correct groups & create missing ones
        for (var i = 0; i < userGroups.length; i++) {
            var groupName = userGroups[i];
            var fullGroupPath = "/Intermate members/" + groupName;

            // Check if the group exists
            var group = realm.getGroupByPath(fullGroupPath);
            if (!group) {
                group = realm.createGroup(groupName, baseGroup);
            }

            // Assign user to the group
            user.joinGroup(group);
            assignedGroups.push(group.getId());
        }

        // Remove user from outdated groups
        for (var j = 0; j < existingGroups.length; j++) {
            var existingGroup = existingGroups[j];

            if (
                existingGroup.getPath().startsWith("/Intermate members/") &&
                !assignedGroups.includes(existingGroup.getId())
            ) {
                user.leaveGroup(existingGroup);
            }
        }
    }
};

