var mapper = {
    /**
     * Function to map SAML groups to Keycloak groups dynamically.
     */
    map: function (context, user, identityProviderMapper) {
        var realm = context.getRealm();
        var groupAttribute = identityProviderMapper.getAttribute("group"); // Adjust based on actual SAML attribute

        if (!groupAttribute) {
            return;
        }

        // Ensure the base group "Intermate members" exists
        var baseGroup = realm.getGroupByPath("/Intermate members");
        if (!baseGroup) {
            baseGroup = realm.createGroup("Intermate members");
        }

        // Convert groupAttribute to an array (handles single & multiple values)
        var userGroups = Array.isArray(groupAttribute) ? groupAttribute : [groupAttribute];

        // Get all existing groups assigned to the user
        var existingGroups = user.getGroups();

        // Track assigned groups
        var assignedGroups = [];
        
        // Assign the user to "Intermate members"
        user.joinGroup(baseGroup);

        // Assign user to correct groups & create missing ones
        for (var i = 0; i < userGroups.length; i++) {
            var groupName = userGroups[i];
            var fullGroupPath = "/Intermate members/" + groupName;

            // Check if the group exists
            var group = realm.getGroupByPath(fullGroupPath);
            if (!group) {
                group = realm.createGroup(groupName, baseGroup);
            }

            // Assign user to the group
            user.joinGroup(group);
            assignedGroups.push(group.getId());
        }

        // Remove user from outdated groups
        for (var j = 0; j < existingGroups.length; j++) {
            var existingGroup = existingGroups[j];

            if (
                existingGroup.getPath().startsWith("/Intermate members/") &&
                !assignedGroups.includes(existingGroup.getId())
            ) {
                user.leaveGroup(existingGroup);
            }
        }
    },

    /**
     * Function to remove users from groups if login fails (user is deleted).
     */
    onFailure: function (context, user, identityProviderMapper) {
	// Do nothing for now
	return;
        var realm = context.getRealm();
        var baseGroup = realm.getGroupByPath("/Intermate members");

        if (user && baseGroup) {
            var userGroups = user.getGroups();
            for (var i = 0; i < userGroups.length; i++) {
                if (userGroups[i].getPath().startsWith("/Intermate members")) {
                    user.leaveGroup(userGroups[i]);
                }
            }
        }
    }
};

